#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//3D Motion IllusionMod01.fsh   by   P_Malin  
//https://www.shadertoy.com/view/XsdcDr
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// 3D Motion Illusion Test - @P_Malin
// https://www.shadertoy.com/view/XsdcDr

// Inspired by patterns from @AkiyoshiKitaoka mapped on a 3D scene.
// https://twitter.com/AkiyoshiKitaoka/status/967758875649699841
// https://twitter.com/AkiyoshiKitaoka/status/970964297550520320
// https://twitter.com/AkiyoshiKitaoka/status/969510301925236736

//#define REVERSE_DIRECTION

#define HEX_PATTERN 0


float MAX_DIST = 1000.0;

#define PI 3.141592654
#define TAU  (PI * 2.0)

vec2 GetWindowCoord( const in vec2 vUV )
{
	vec2 vWindow = vUV * 2.0 - 1.0;
	vWindow.x *= iResolution.x / iResolution.y;

	return vWindow;	
}

vec3 GetCameraRayDir( const in vec2 vWindow, const in vec3 vCameraPos, const in vec3 vCameraTarget )
{
	vec3 vForward = normalize(vCameraTarget - vCameraPos);
	vec3 vRight = normalize(cross(vec3(0.0, 1.0, 0.0), vForward));
	vec3 vUp = normalize(cross(vForward, vRight));
							  
    float fPersp = 3.0;
	vec3 vDir = normalize(vWindow.x * vRight + vWindow.y * vUp + vForward * fPersp);

	return vDir;
}

vec2 Scene_GetDistance( vec3 vPos )
{
	vec2 vResult = vec2( MAX_DIST, 0.0 );

#if 0
    float fTunnelDist = 20.0 - length(vPos.xy);        
    if ( fTunnelDist < vResult.x )
    {
        vResult = vec2( fTunnelDist, atan(vPos.x, vPos.y) * 150.0 / (3.14 * 2.0) );
    }
	return vResult;
#else   
    float fFloorPlaneDist = 10.0 + vPos.y;
    if ( fFloorPlaneDist < vResult.x )
    {
        vResult = vec2( fFloorPlaneDist, vPos.x * 1.5 );
    }

    float fCeilPlaneDist = 18.6 - vPos.y;
    if ( fCeilPlaneDist < vResult.x )
    {
        vResult = vec2( fCeilPlaneDist, vPos.x * 1.5 );
    }
    
    float fTunnelDist = 20.0 - length(vPos.xy);        
    if ( fTunnelDist < vResult.x )
    {
        vResult = vec2( fTunnelDist, atan(vPos.x, vPos.y) * 150.0 / (3.14 * 2.0) );
    }

    vec3 vRailDomain = vPos;
    vRailDomain.x = abs( vRailDomain.x );
    
    float fRailDist = length(vRailDomain.xy - vec2(10.0, -9.0)) - 1.0;
    if ( fRailDist < vResult.x )
    {
        vResult = vec2( fRailDist, 0.0 );
    }

    float fSideRailDist = length(vRailDomain.xy - vec2(19.0, -1.5)) - 2.0;
    if ( fSideRailDist < vResult.x )
    {
        vResult = vec2( fSideRailDist, 0.0 );
    }
#endif    
        
    return vResult;
}

vec3 Scene_GetNormal( const in vec3 vPos )
{
    const float fDelta = 0.0001;
    vec2 e = vec2( -1, 1 );
    
    vec3 vNormal = 
        Scene_GetDistance( e.yxx * fDelta + vPos ).x * e.yxx + 
        Scene_GetDistance( e.xxy * fDelta + vPos ).x * e.xxy + 
        Scene_GetDistance( e.xyx * fDelta + vPos ).x * e.xyx + 
        Scene_GetDistance( e.yyy * fDelta + vPos ).x * e.yyy;
    
    return normalize( vNormal );
}   

vec2 Scene_Trace( vec3 vRayOrigin, vec3 vRayDir, float minDist, float maxDist )
{	
    vec2 vResult = vec2(0, 0);
    
	float t = minDist;
	const int kRaymarchMaxIter = 64;
	for(int i=0; i<kRaymarchMaxIter; i++)
	{		
        float epsilon = 0.0001 * t;
		vResult = Scene_GetDistance( vRayOrigin + vRayDir * t );
        if ( abs(vResult.x) < epsilon )
		{
			break;
		}
                        
        if ( t > maxDist )
        {
	        t = maxDist;
            break;
        }               
        
        t += vResult.x;
	}
    
    vResult.x = t;
    
    return vResult;
}    


#if HEX_PATTERN

// Returns vec4( distance to edge, distance to centre, vec2( hexagon co-ordinate ) )
// hexagon co-ordinate integer part is hexagon I.D.
// hexagon co-ordinate fractional part is uv within the hexagon
vec4 Hexagon( vec2 pos ) 
{
    vec2 vScale = vec2( 1.0f, sqrt(3.0f) );
    
    vec2 p = pos * vScale;
      
    // :
    // :
    // o--+--+--+--+--+--o
    // |  : /:  |  :\ :  |
    // |  :/ :  |  : \:  |
    // +--+--+--o--+--+--+
    // |  :\ :  |  : /:  |
    // |  : \:  |  :/ :  |
    // o--+--+--+--+--+--o - - - - 
    
    vec2 f = fract( p );
    
    vec2 index = floor( p );
    index.x *= 2.0f;
    
    vec2 c;    
    
    vec2 t = abs( f - vec2(0.5, 0.5) );

    // get hexagon center and index
    
    // (6.0, 2.0) = dimensions of repeating grid above
    if ( t.x * 6.0 < -t.y * 2.0 + 2.0 )
    {
        c = vec2(0.5);        
    }
    else
    {
        if ( f.x > 0.5f )
        {
            c.x = 1.0f; 

            index.x += 1.0f;
        }
        else
        {
            index.x -= 1.0f;
            c.x = 0.0f;
        }
        
        if ( f.y > 0.5f )
        {
            c.y = 1.0f;            
            index.y += 1.0f;
        }
        else
        {
            c.y = 0.0f;
        }
    }
            
    vec2 offset = (f - c) / vScale;
    float d = length( offset );
    
    vec2 vDir[3] = vec2[3]( 
        vec2(  0.0f, 				1.0f ), 
        vec2( -sqrt(3.0f) / 2.0f,	1.0f / 2.0f ),
        vec2(  sqrt(3.0f) / 2.0f,	1.0f / 2.0f ) );    
    
    float s = 10000.0;
    
    for ( int i=0; i<3; i++ )
    {
        float d = 1.0 - abs( dot( offset, vDir[i] ) ) * 2.0 * sqrt(3.0);
        s = min( s, d );
    }
    
    vec2 vUV = index + offset * 1.5 + 0.5;
    
    return vec4(s, d, vUV );
}


vec3 HexPattern( vec2 vUV, vec3 colInner, vec3 colEdge )
{
    vec4 hex = Hexagon( vUV );
    
    float edgeShade = step( fract(hex.w), 0.5 );

    vec3 col = colInner; 
    col = mix( col, vec3(edgeShade), step(hex.x, 0.3) ); // black / white edge
    col = mix( col, colEdge, step(hex.x, 0.15) ); ; // Yellow Surround
        
    return col;
}


#endif



vec3 MotionTextureGradient( float f )
{
#if 0
    vec3 cols[] = vec3[](
        vec3(1,0,0),
        vec3(1,0,1),
        vec3(0.95,0,1) * 0.75
        );

    f *= float( cols.length() );    

    int c1 = int( floor(f) ) % cols.length();
    int c2 = (c1 + 1) % cols.length();
    float b = clamp( f - float(c1), 0.0, 1.0 );
    
    //b = smoothstep(0.0,1.0,b);
    return mix( cols[c1], cols[c2], b );    
#else    
    vec3 vColA = vec3( 253, 27, 32 ) / 255.0;
	vec3 vColB = vec3( 198, 48, 249 ) / 255.0;
    
    //vec3 vColA = vec3(1,1,0);
    //vec3 vColB = vec3(1,.1,0);
        
    float fCol = sin(f * TAU) * 0.5 + 0.5;
    float fLum = sin((f + 0.25) * TAU) * 0.5 + 0.5;
        
    float fLumA = 0.9;
    float fLumB = 1.0;

    return mix( vColA, vColB, fCol ) * mix( fLumA, fLumB, fLum );
#endif    
}

vec3 MotionTexture( vec2 vUV )
{
#if HEX_PATTERN
    return HexPattern( vUV * 1.0 + 0.1, vec3(113, 36, 132) / 255., vec3(198, 161, 57) / 255. );
#else
    float x = fract( vUV.x );

    float fOffset = floor( x * 2.0 ) / 2.0;
    float y = fract( vUV.y + fOffset );
    
	return MotionTextureGradient( y );
#endif    
}

vec3 GetSceneColour( const in vec3 vRayOrigin,  const in vec3 vRayDir )
{
    float theta = atan(vRayDir.x, vRayDir.y);
    vec2 vScene = Scene_Trace( vRayOrigin, vRayDir, 0.0, MAX_DIST );
    float fDist = vScene.x;
	vec3 vPos = vRayOrigin + vRayDir * fDist;
	
    vec3 vNormal = Scene_GetNormal( vPos );
    vec2 vUV = vScene.yx * vec2(0.1, 0.05); 
    
    if ( fDist > 350.0 )
    {
        vUV = vec2(0);
    }   

#ifdef REVERSE_DIRECTION
    vUV.y = 1.0 - vUV.y;
#endif    
    
    vec3 vTex = MotionTexture(vUV + 0.25);
    
    vTex = vTex * vTex;
    float t = fDist * fDist;
    float fFog = 1.0 - exp2( -t * 0.00005 );
    vec3 vFogColor = vec3(0.0);
    vec3 vResult = mix( vTex, vFogColor, fFog );
    
    return sqrt(vResult);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec2 vUV = fragCoord.xy / iResolution.xy;

	vec3 vCameraPos = vec3(0.0, 0.0, 0.0);
	vec3 vCameraTarget = vec3(0.0, 0.0, 10.0);
    
	vec3 vRayOrigin = vCameraPos;
	vec3 vRayDir = GetCameraRayDir( GetWindowCoord(vUV), vCameraPos, vCameraTarget );
	
	vec3 vResult = GetSceneColour(vRayOrigin, vRayDir);
	    
	fragColor = vec4(vResult, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

